<?php
require_once "../includes/config.php";
require_once "../includes/functions.php";

$item_id = $_GET['id'];
$branch_id = $_GET['branch'];
$lang = $_GET['lang'] ?? "ar";
$folder = basename(dirname(__FILE__));

$restaurant = get_restaurant_by_folder($folder);
$item = get_item_details($item_id, $branch_id, $restaurant['id']);

$w = 1080;
$h = 1920;

/* إنشاء الصورة */
$img = imagecreatetruecolor($w,$h);

/* خلفية Gradient */
for($i=0;$i<$h;$i++){
    $r = 20 + ($i / $h) * 30;
    $g = 20 + ($i / $h) * 20;
    $b = 20 + ($i / $h) * 20;
    $color = imagecolorallocate($img,$r,$g,$b);
    imageline($img,0,$i,$w,$i,$color);
}

/* صورة المنتج */
$prod = "../uploads/Items/".$item['image'];
if(file_exists($prod)){
    $src = imagecreatefromjpeg($prod);
    $srcW = imagesx($src);
    $srcH = imagesy($src);

    /* تصغير الصورة بمقاس مناسب دون قصّ */
    $newW = 900;
    $newH = intval($srcH * ($newW / $srcW));

    $dstY = 120;
    imagecopyresampled($img,$src,90,$dstY,0,0,$newW,$newH,$srcW,$srcH);
}

/* نصوص */
$white = imagecolorallocate($img,255,255,255);
$gray  = imagecolorallocate($img,200,200,200);
$yellow = imagecolorallocate($img,255,205,55);

$fontBold = "fonts/Tajawal-Bold.ttf";
$fontReg  = "fonts/Tajawal-Regular.ttf";

/* اسم الصنف */
imagettftext($img, 52, 0, 60, 1150, $white, $fontBold, $item["name_$lang"]);

/* وصف مختصر */
$desc = mb_substr($item["description_$lang"],0,120);
imagettftext($img, 34, 0, 60, 1230, $gray, $fontReg, $desc);

/* السعر */
imagettftext($img, 60, 0, 60, 1350, $yellow, $fontBold, number_format($item['final_price'])." IQD");

/* رابط نصّي */
$link = "https://".$_SERVER['HTTP_HOST']."/menu/$folder/item.php?id=$item_id&branch=$branch_id&lang=$lang";
imagettftext($img, 30, 0, 60, 1450, $gray, $fontReg, $link);

/* QR Code */
$qr = "../qr_temp_$item_id.png";
file_put_contents($qr, file_get_contents("https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=$link"));
$qrImg = imagecreatefrompng($qr);
imagecopyresampled($img,$qrImg,380,1500,0,0,320,320,imagesx($qrImg),imagesy($qrImg));

unlink($qr);

/* إخراج الصورة */
header("Content-Type: image/jpeg");
imagejpeg($img, null, 90);

imagedestroy($img);
