<?php
require_once __DIR__ . "/includes/auth.php";
ensure_super_admin();

require_once __DIR__ . "/includes/functions.php";
require_once __DIR__ . "/lib/phpqrcode/qrlib.php";


// جلب قائمة المطاعم
$restaurants = fetch_all("SELECT id, name, folder_name FROM restaurants ORDER BY name ASC");

// هل تم اختيار مطعم؟
$rest_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$selected_rest = $rest_id ? get_restaurant($rest_id) : null;


// إذا تم توليد الكود
if ($rest_id && isset($_GET['generate'])) {

    if (!$selected_rest) die("المطعم غير موجود");

    $folder = $selected_rest['folder_name'];
    $url = "https://meta-qr.com/menu/$folder/";
    $qr_folder = __DIR__ . "/qr_images";

    if (!file_exists($qr_folder)) {
        mkdir($qr_folder, 0777, true);
    }

    $qr_img = "$qr_folder/qr_restaurant_$rest_id.png";

    // توليد QR بجودة عالية
    QRcode::png($url, $qr_img, QR_ECLEVEL_H, 20, 1);

    header("Location: restaurant_qr.php?id=$rest_id");
    exit;
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>توليد QR للمطعم</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
body{
    margin:0;
    padding:0;
    background:#0f0f11;
    font-family:"Tajawal",sans-serif;
    color:#fff;
    display:flex;
}

.content{
    margin-right:300px;
    padding:35px;
    width:100%;
}

.section-title{
    font-size:24px;
    margin-bottom:20px;
    color:#9c6bff;
}

select,input,button{
    padding:10px;
    border-radius:8px;
    border:none;
    margin-top:8px;
}

button{
    background:#9c6bff;
    color:#000;
    font-weight:bold;
    cursor:pointer;
}

button:hover{ opacity:0.85; }

.box{
    background:#1b1b22;
    padding:20px;
    border-radius:12px;
    border:1px solid #2a2933;
}

img.qr{
    max-width:350px;
    background:#fff;
    padding:15px;
    border-radius:12px;
}
</style>

</head>
<body>

<?php include "includes/sidebar.php"; ?>

<div class="content">
<h2 class="section-title">توليد QR للمطعم</h2>

<div class="box">

<form method="GET" action="restaurant_qr.php">
<label>اختر مطعم:</label><br>
<select name="id" onchange="this.form.submit()">
    <option value="">— اختر مطعم —</option>
    <?php foreach ($restaurants as $r): ?>
        <option value="<?= $r['id'] ?>" <?= ($rest_id == $r['id']) ? "selected" : "" ?>>
            <?= $r['name'] ?>
        </option>
    <?php endforeach; ?>
</select>
</form>

<br>

<?php if($selected_rest): ?>

<?php
    $qr_file = __DIR__ . "/qr_images/qr_restaurant_$rest_id.png";
    $qr_exists = file_exists($qr_file);
?>

<hr style="border-color:#333;">

<h3 style="color:#9c6bff;">QR الخاص بالمطعم: <?= $selected_rest['name'] ?></h3>

<?php if($qr_exists): ?>

    <img src="qr_images/qr_restaurant_<?= $rest_id ?>.png" class="qr"><br><br>

    <a href="qr_images/qr_restaurant_<?= $rest_id ?>.png" download>
        <button>تحميل QR بدقة عالية</button>
    </a>

    <a href="restaurant_qr.php?id=<?= $rest_id ?>&generate=1">
        <button style="background:#ff4f4f;">إعادة توليد QR</button>
    </a>

<?php else: ?>

    <p>لم يتم توليد QR بعد لهذا المطعم.</p>
    <a href="restaurant_qr.php?id=<?= $rest_id ?>&generate=1">
        <button>توليد QR الآن</button>
    </a>

<?php endif; ?>

<?php endif; ?>

</div>
</div>

</body>
</html>
