<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


require_once __DIR__ . "/includes/auth.php";
ensure_super_admin();

require_once __DIR__ . "/includes/functions.php";


// إحصائيات عامة
$total_restaurants = fetch_value("SELECT COUNT(*) FROM restaurants");
$total_visits      = total_visits_all();
$visits_today      = total_visits_today();

// أقرب 5 اشتراكات ستنتهي
$expiring = fetch_all("
    SELECT id, name, subscription_end
    FROM restaurants
    WHERE subscription_end IS NOT NULL
    ORDER BY subscription_end ASC
    LIMIT 5
");

// جلب آخر 10 مطاعم
$restaurants = fetch_all("
    SELECT r.*, 
    (SELECT COUNT(*) FROM branches b WHERE b.restaurant_id = r.id) AS branch_count
    FROM restaurants r
    ORDER BY r.id DESC
    LIMIT 10
");
$expiring = fetch_all("
    SELECT id, name, subscription_type, subscription_end
    FROM restaurants
    WHERE subscription_end IS NOT NULL
    ORDER BY subscription_end ASC
    LIMIT 5
");

// حساب لون الأيام المتبقية
function sub_color($days)
{
    if ($days < 10) return "red";
    if ($days < 20) return "yellow";
    return "green";
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة التحكم</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>

body{
    margin:0;
    padding:0;
    background:#0f0f11;
    font-family:"Tajawal",sans-serif;
    color:#fff;
    display:flex;
}

/* SIDEBAR */
.sidebar {
    width:260px;
    background:#15151a;
    height:100vh;
    position:fixed;
    right:0;
    top:0;
    border-left:1px solid #302f3a;
    padding:25px;
}

.sidebar h3{
    color:#9c6bff;
    font-size:22px;
    margin-bottom:25px;
}

.sidebar a{
    display:block;
    padding:12px 16px;
    background:#1e1d26;
    margin-bottom:10px;
    color:#fff;
    text-decoration:none;
    border-radius:8px;
    border:1px solid #2a2933;
    transition:0.2s;
}

.sidebar a:hover{
    background:#9c6bff;
    color:#000;
}

.sidebar .logout{
    background:#b30000;
}
.sidebar .logout:hover{
    background:#e00000;
}

/* CONTENT */
.content{
    margin-right:300px;
    padding:35px;
    width:100%;
}

.section-title{
    font-size:24px;
    margin-bottom:20px;
    color:#9c6bff;
}

/* CARDS */
.cards{
    display:grid;
    grid-template-columns:repeat(3,1fr);
    gap:20px;
    margin-bottom:35px;
}

.card{
    background:#1b1b22;
    padding:25px;
    border-radius:12px;
    border:1px solid #2a2933;
    box-shadow:0 0 6px rgba(0,0,0,0.3);
}

.card h4{
    margin:0;
    color:#ccc;
    font-size:18px;
}

.card .num{
    margin-top:10px;
    font-size:32px;
    font-weight:bold;
    color:#9c6bff;
}

/* TABLE */
.table-box{
    margin-top:30px;
    background:#1b1b22;
    padding:20px;
    border-radius:12px;
    border:1px solid #2a2933;
}

table{
    width:100%;
    border-collapse:collapse;
}

th, td{
    padding:12px;
    border-bottom:1px solid #2a2933;
}

th{
    background:#26252f;
    color:#9c6bff;
    text-align:right;
}

.badge{
    padding:6px 10px;
    border-radius:6px;
    color:#000;
    font-weight:bold;
}
.red { background:#ff4f4f; }
.yellow { background:#ffe15d; }
.green { background:#73ff81; }

.btn-sm{
    padding:6px 12px;
    background:#9c6bff;
    color:#000;
    text-decoration:none;
    border-radius:6px;
    font-weight:bold;
}
.btn-sm:hover{
    opacity:0.85;
}
</style>

</head>
<body>

<?php include "includes/sidebar.php"; ?>

<div class="content">

<h2 class="section-title">لوحة التحكم</h2>

<!-- STATISTICS CARDS -->
<div class="cards">

    <div class="card">
        <h4>عدد المطاعم</h4>
        <div class="num"><?= $total_restaurants ?></div>
    </div>

    <div class="card">
        <h4>إجمالي الزيارات</h4>
        <div class="num"><?= $total_visits ?: 0 ?></div>
    </div>

    <div class="card">
        <h4>أقرب انتهاء اشتراك</h4>
        <div class="num">
            <?php
            if (!empty($expiring)) {
                $d = (strtotime($expiring[0]['subscription_end']) - time()) / 86400;
                echo ceil($d) . " يوم";
            } else {
                echo "—";
            }
            ?>
        </div>
    </div>

</div>


<!-- TABLE: EXPIRING SUBSCRIPTIONS -->
<div class="table-box">
    <h3 style="color:#9c6bff;">الاشتراكات التي ستنتهي قريباً</h3>

    <table>
        <tr>
            <th>المطعم</th>
            <th>نوع الاشتراك</th>
            <th>ينتهي في</th>
            <th>الأيام المتبقية</th>
        </tr>

        <?php foreach ($expiring as $ex): 
            $days = ceil((strtotime($ex['subscription_end']) - time()) / 86400);
            if ($days < 0) $days = 0;
        ?>
        <tr>
            <td><?= $ex['name'] ?></td>
            <td><?= $ex['subscription_type'] ?></td>
            <td><?= $ex['subscription_end'] ?></td>
            <td>
                <span class="badge <?= sub_color($days) ?>">
                    <?= $days ?> يوم
                </span>
            </td>
        </tr>
        <?php endforeach; ?>

    </table>
</div>


<!-- TABLE: LAST RESTAURANTS -->
<br>
<div class="table-box">
    <h3 style="color:#9c6bff;">آخر المطاعم المضافة</h3>

    <table>
        <tr>
            <th>الاسم</th>
            <th>عدد الفروع</th>
            <th>اللغات</th>
            <th>الاشتراك</th>
            <th>الحالة</th>
            <th>تحكم</th>
        </tr>

<?php foreach ($restaurants as $r): ?>
<?php
    $lang_rows = get_restaurant_languages($r['id']);
    $langs = [];
    foreach ($lang_rows as $lr) {
        $langs[] = $lr['code'];
    }
    $langs_str = implode(" / ", $langs ?: ['ar']);
?>



<tr>
    <td><?= $r['name'] ?></td>
    <td><?= $r['branch_count'] ?></td>
    <td><?= $langs_str ?></td>
    <td><?= $r['subscription_type'] ?></td>

    <td>
        <span class="badge <?= $r['active'] ? "green" : "red" ?>">
            <?= $r['active'] ? "فعال" : "متوقف" ?>
        </span>
    </td>

    <td>
        <a href="restaurant_edit.php?id=<?= $r['id'] ?>" class="btn-sm">تعديل</a>
        <a href="restaurant_delete.php?id=<?= $r['id'] ?>" class="btn-sm" style="background:#ff4f4f;">حذف</a>
    </td>
</tr>

<?php endforeach; ?>


    </table>
</div>


</div>

</body>
</html>
