let liveInterval = 12000;

// استخدم رابط مطلق (مثل ما قلت اشتغل معك)
let audio = new Audio("https://www.meta-qr.com/menu/manager/assets/notify.mp3");

// لازم تفاعل مستخدم واحد على الأقل حتى يسمح المتصفح بالصوت
let soundEnabled = false;

function enableSoundOnce() {
  if (soundEnabled) return;

  audio.play().then(() => {
    audio.pause();
    audio.currentTime = 0;
    soundEnabled = true;
  }).catch(() => {});
}

// فعّل الصوت عند أول تفاعل بأي مكان (مو بس sidebar)
document.addEventListener("pointerdown", enableSoundOnce, { once: true, capture: true });
document.addEventListener("keydown", enableSoundOnce, { once: true, capture: true });

// أول دخول للصفحة: init لتثبيت الأساس (بدون صوت)
function initLiveReservations(){
  fetch("api/live_reservations.php?init=1", { cache: "no-store" })
    .then(r => r.json())
    .then(d => {
      const c = document.getElementById("liveCount");
      if (c && typeof d.count !== "undefined") c.innerText = d.count;
    })
    .catch(()=>{});
}

// فحص الحجوزات بعد التهيئة
function checkLiveReservations(){
  fetch("api/live_reservations.php", { cache: "no-store" })
    .then(r => r.json())
    .then(d => {
      if (d.play && soundEnabled) {
        audio.currentTime = 0;
        audio.play().catch(()=>{});
      }

      const c = document.getElementById("liveCount");
      if (c && typeof d.count !== "undefined") c.innerText = d.count;
    })
    .catch(()=>{});
}

initLiveReservations();
setInterval(checkLiveReservations, liveInterval);
