<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . "/includes/config.php";
require_once __DIR__ . "/includes/functions.php";

// --------------------------
// GET RESTAURANT BY FOLDER
// --------------------------
$folder = basename(__DIR__);
$restaurant = get_restaurant($folder);
if (!$restaurant) die("Restaurant Not Found");

// --------------------------
// LANGUAGE
// --------------------------
$lang = $_GET['lang'] ?? ($_SESSION['lang'] ?? "ar");
$_SESSION['lang'] = $lang;

// تحميل ملف اللغة الصحيح
if (file_exists(__DIR__ . "/lang/{$lang}.php")) {
    include __DIR__ . "/lang/{$lang}.php";
}

// --------------------------
// GET BRANCHES
// --------------------------
$sql = "SELECT * FROM branches WHERE restaurant_id = ? AND active = 1 ORDER BY ordering ASC";
$stmt = db()->prepare($sql);
$stmt->execute([$restaurant['id']]);
$branches = $stmt->fetchAll(PDO::FETCH_ASSOC);

// If only 1 branch → redirect automatically
if (count($branches) == 1) {
    $single = $branches[0];
    header("Location: branch.php?id={$single['id']}&lang={$lang}");
    exit;
}

// --------------------------
// Dynamic Theme Colors
// --------------------------
$primary      = $restaurant['theme_text_color']      ?? "#ffffff";
$secondary    = $restaurant['theme_color']           ?? "#ff7a00";
$background   = $restaurant['theme_background']      ?? "#000000";

?>
<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $lang == 'ar' ? 'rtl' : 'ltr' ?>">
<head>
<meta charset="UTF-8">
<title><?= $restaurant['name_'.$lang] ?: $restaurant['name'] ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>

:root {
    --primary:   <?= $primary ?>;
    --secondary: <?= $secondary ?>;
    --bg:        <?= $background ?>;
}

body {
    margin:0;
    padding:0;
    background: var(--bg);
    color: var(--primary);
    font-family: "Tajawal", sans-serif;
}

/* HERO WRAPPER */
.hero-wrapper {
    position: relative;
    width:100%;
    height:100vh;
    overflow:hidden;
}

.hero-video,
.hero-image {
    width:100%;
    height:100%;
    object-fit:cover;
    position:absolute;
    top:0;
    left:0;
    z-index:-2;
}

.overlay {
    position:absolute;
    top:0; left:0;
    width:100%; height:100%;
    background:rgba(0,0,0,0.55);
    z-index:-1;
}

/* CONTENT */
.home-content {
    position:absolute;
    top:50%;
    left:50%;
    transform:translate(-50%,-50%);
    text-align:center;
    width:90%;
}

.rest-logo {
    width:150px;
    border-radius:15px;
    margin-bottom:15px;
}

/* LANGUAGE SWITCH */
.language-switch {
    margin-top:15px;
    display:flex;
    justify-content:center;
    gap:10px;
}

.language-switch a {
    padding:8px 16px;
    background:#222;
    border:1px solid var(--secondary);
    color:var(--secondary);
    border-radius:20px;
    text-decoration:none;
    font-size:14px;
}

/* BRANCHES GRID */
.branches-grid {
    margin-top:30px;
    display:grid;
    gap:16px;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
}

.branch-card {
    background:#111;
    border-radius:16px;
    overflow:hidden;
    box-shadow:0 0 12px rgba(0,0,0,0.5);
    cursor:pointer;
    transition:.2s;
}

.branch-card:hover {
    transform:scale(1.03);
}

.branch-cover img,
.branch-cover video {
    width:100%;
    height:160px;
    object-fit:cover;
}

.branch-info {
    padding:15px;
    text-align:center;
}

.branch-name {
    font-size:20px;
    font-weight:bold;
    margin-bottom:10px;
}

.branch-btn {
    display:inline-block;
    margin-top:10px;
    padding:10px 22px;
    background:var(--secondary);
    color:#000;
    font-weight:bold;
    border-radius:10px;
    text-decoration:none;
    font-size:16px;
}

</style>
</head>

<body>

<!-- HERO (video/image) -->
<div class="hero-wrapper">

    <?php if($restaurant['background_video']): ?>
        <video autoplay muted loop class="hero-video">
            <source src="../<?= $restaurant['background_video'] ?>" type="video/mp4">
        </video>
    <?php elseif($restaurant['background_image']): ?>
        <img src="../<?= $restaurant['background_image'] ?>" class="hero-image">
    <?php endif; ?>

    <div class="overlay"></div>

    <div class="home-content">

        <!-- Restaurant Logo -->
        <?php if ($restaurant['logo']): ?>
            <img src="../<?= $restaurant['logo'] ?>" class="rest-logo">
        <?php endif; ?>

        <!-- Restaurant Name -->
        <h1><?= $restaurant['name_'.$lang] ?: $restaurant['name'] ?></h1>

        <!-- Language Switch -->
        <div class="language-switch">
            <a href="?lang=ar">عربي</a>
            <a href="?lang=en">English</a>
            <a href="?lang=ku">کوردی</a>
        </div>

        <!-- Choose Branch -->
        <h3 style="margin-top:20px;"><?= $tr['choose_branch'] ?? "اختر الفرع" ?></h3>

        <!-- Branches Grid -->
        <div class="branches-grid">

            <?php foreach($branches as $b): ?>
            <div class="branch-card" onclick="location.href='branch.php?id=<?= $b['id'] ?>&lang=<?= $lang ?>'">

                <div class="branch-cover">
                    <?php if($b['cover_video']): ?>
                        <video autoplay muted loop>
                            <source src="../<?= $b['cover_video'] ?>" type="video/mp4">
                        </video>
                    <?php elseif($b['cover_image']): ?>
                        <img src="../<?= $b['cover_image'] ?>">
                    <?php endif; ?>
                </div>

                <div class="branch-info" 
                     style="background:<?= $b['theme_background'] ?>;
                            color:<?= $b['theme_text_color'] ?>">

                    <div class="branch-name">
                        <?= $b["name_{$lang}"] ?: $b['name'] ?>
                    </div>

                    <a class="branch-btn" 
                       style="background:<?= $b['theme_color'] ?>"
                       href="branch.php?id=<?= $b['id'] ?>&lang=<?= $lang ?>">
                       <?= $tr['enter_branch'] ?? "ادخل الفرع" ?>
                    </a>
                </div>

            </div>
            <?php endforeach; ?>

        </div>

    </div>

</div>

</body>
</html>
