<?php

function login($email, $password) {
    global $pdo;

    $stm = $pdo->prepare("SELECT * FROM users WHERE email=? AND password=MD5(?) AND active=1");
    $stm->execute([$email, $password]);

    $user = $stm->fetch();

    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['role']    = $user['role'];
        $_SESSION['default_lang'] = $user['default_lang'];
        return true;
    }
    return false;
}

function logout() {
    session_destroy();
}

function is_logged_in() {
    return isset($_SESSION['user_id']);
}

function is_super_admin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'super_admin';
}

function is_manager() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'manager';
}

function require_login() {
    if (!is_logged_in()) {
        header("Location: ../login.php");
        exit;
    }
}

?>
