<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "../includes/config.php";
require_once "../includes/functions.php";

/* -----------------------------------
   GET RESTAURANT BY FOLDER
----------------------------------- */
$folder = basename(dirname(__FILE__));
$restaurant = get_restaurant_by_folder($folder);
if (!$restaurant) die("Restaurant Not Found");

/* -----------------------------------
   LANGUAGE
----------------------------------- */
if (session_status() === PHP_SESSION_NONE) session_start();

$lang = $_GET['lang'] ?? ($_SESSION['lang'] ?? "ar");
$_SESSION['lang'] = $lang;

$lang_file = __DIR__ . "/lang/{$lang}.php";
if (file_exists($lang_file)) include $lang_file;
else $tr = [];

/* -----------------------------------
   GET ACTIVE LANGUAGES FOR RESTAURANT
----------------------------------- */
$active_langs = fetch_all("
    SELECT l.code 
    FROM restaurant_languages rl
    JOIN languages l ON l.id = rl.language_id
    WHERE rl.restaurant_id=? AND rl.active=1
", [$restaurant['id']]);
$active_langs = $active_langs ? array_column($active_langs, 'code') : ['ar'];

/* -----------------------------------
   GET BRANCHES
----------------------------------- */
$branches = fetch_all("
    SELECT * FROM branches 
    WHERE restaurant_id=? AND active=1 
    ORDER BY ordering ASC
", [$restaurant['id']]);

/* -----------------------------------
   AUTO REDIRECT IF RESTAURANT HAS BRANCHES (1 or more)
----------------------------------- */
if (count($branches) >= 1) {
    $first = $branches[0];
    header("Location: branch.php?id={$first['id']}&lang={$lang}");
    exit;
}

/* -----------------------------------
   NAME FUNCTION
----------------------------------- */
function show_name($row, $lang) {
    if ($lang == "en" && !empty($row['name_en'])) return $row['name_en'];
    if ($lang == "ku" && !empty($row['name_ku'])) return $row['name_ku'];
    return $row['name'];
}

/* -----------------------------------
   COLORS
----------------------------------- */
$primary      = $restaurant['theme_text_color'] ?? "#ffffff";
$secondary    = $restaurant['theme_color'] ?? "#ff7a00";
$background   = $restaurant['theme_background'] ?? "#000000";

/* -----------------------------------
   SOCIAL + CONTACT
----------------------------------- */
$phone     = $restaurant['phone'] ?? "";
$whatsapp  = $restaurant['whatsapp'] ?? "";
$facebook  = $restaurant['facebook'] ?? "";
$instagram = $restaurant['instagram'] ?? "";
$location  = $restaurant['location'] ?? "";
$website   = $restaurant['website'] ?? ""; // زر موقع خارجي (إن وجد بقاعدة البيانات)

?>

<!DOCTYPE html>
<html lang="<?= $lang ?>" dir="<?= $lang == 'ar' ? 'rtl' : 'ltr' ?>">
<head>
<meta charset="UTF-8">
<title><?= show_name($restaurant, $lang) ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
:root {
    --primary:   <?= $primary ?>;
    --secondary: <?= $secondary ?>;
    --bg:        <?= $background ?>;
}

body {
    margin:0;
    padding:0;
    background: var(--bg);
    color: var(--primary);
    font-family: "Tajawal", sans-serif;
    text-align:center;
}

/* HERO WRAPPER */
.hero-wrapper {
    position: relative;
    width:100%;
    height:100vh;
    overflow:hidden;
}

.hero-video,
.hero-image {
    width:100%;
    height:100%;
    object-fit:cover;
    position:absolute;
    top:0;
    left:0;
    z-index:-2;
}

.overlay {
    position:absolute;
    top:0; left:0;
    width:100%; height:100%;
    background:rgba(0,0,0,0.55);
    z-index:-1;
}

/* CONTENT */
.home-content {
    position:absolute;
    top:50%;
    left:50%;
    transform:translate(-50%,-50%);
    width:90%;
}

.rest-logo {
    width:160px;
    border-radius:15px;
    margin-bottom:15px;
}

/* LANGUAGE SWITCH */
.language-switch {
    margin-top:15px;
    display:flex;
    justify-content:center;
    gap:10px;
}

.language-switch a {
    padding:8px 16px;
    background:#222;
    border:1px solid var(--secondary);
    color:var(--secondary);
    border-radius:20px;
    text-decoration:none;
    font-size:14px;
}

/* BUTTONS */
.btn-main {
    display:block;
    margin:12px auto;
    padding:12px 25px;
    background:var(--secondary);
    color:#000;
    font-weight:bold;
    border-radius:10px;
    text-decoration:none;
    font-size:17px;
    width:200px;
}

/* CONTACT */
.contact {
    margin-top:20px;
    font-size:16px;
}

.social a {
    margin:0 6px;
    font-size:22px;
    color:var(--primary);
    text-decoration:none;
}

</style>
</head>

<body>

<!-- HERO (video/image) -->
<div class="hero-wrapper">

    <?php if($restaurant['background_video']): ?>
        <video autoplay muted loop class="hero-video">
            <source src="../<?= $restaurant['background_video'] ?>" type="video/mp4">
        </video>
    <?php elseif($restaurant['background_image']): ?>
        <img src="../<?= $restaurant['background_image'] ?>" class="hero-image">
    <?php endif; ?>

    <div class="overlay"></div>

    <div class="home-content">

        <!-- Restaurant Logo -->
        <?php if ($restaurant['logo']): ?>
            <img src="../<?= $restaurant['logo'] ?>" class="rest-logo">
        <?php endif; ?>

        <!-- Restaurant Name -->
        <h1><?= show_name($restaurant, $lang) ?></h1>

        <!-- Language Switch -->
        <div class="language-switch">
            <?php foreach($active_langs as $l): ?>
                <a href="?lang=<?= $l ?>"><?= strtoupper($l) ?></a>
            <?php endforeach; ?>
        </div>

        <!-- Buttons -->
        <a class="btn-main" href="menu.php?lang=<?= $lang ?>">
            <?= $tr['view_menu'] ?? ($lang=='en'?'Menu':($lang=='ku'?'مینیۆ':'المنيو')) ?>
        </a>

        <?php if($website): ?>
        <a class="btn-main" href="<?= $website ?>" target="_blank">
            <?= $tr['visit_website'] ?? ($lang=='en'?'Website':($lang=='ku'?'ماوەکە':'الموقع')) ?>
        </a>
        <?php endif; ?>

        <!-- CONTACT & SOCIAL -->
        <div class="contact">
            <?php if($phone): ?>📞 <?= $phone ?><br><?php endif; ?>
            <?php if($whatsapp): ?>📱 WhatsApp: <?= $whatsapp ?><br><?php endif; ?>
            <?php if($location): ?>📍 <?= $location ?><br><?php endif; ?>
        </div>

        <div class="social" style="margin-top:5px;">
            <?php if($facebook): ?><a href="<?= $facebook ?>" target="_blank">📘</a><?php endif; ?>
            <?php if($instagram): ?><a href="<?= $instagram ?>" target="_blank">📸</a><?php endif; ?>
        </div>

    </div>

</div>

</body>
</html>
